
  /*
   *  Object %name    : % CRYS_ATP_TST_UTIL_OTF_Funcs.c
   *  State           :  %state%
   *  Creation date   :  03 Oct 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_UTIL_OTF_Funcs.c#1:csrc:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/


#include "DX_VOS_Mem.h"
#include "DX_VOS_Sem.h"
#include "DX_VOS_Memmap.h"
#include "DX_VOS_BaseTypes.h"
#include "PLAT_SystemDep.h"
#include "CRYS_COMMON.h"
#include "env_hw_defs.h"
//#include "LLF_COMMON_TST_CSI.h"
#include "CRYS_ATP_TST_UTIL_OTF_Funcs.h"
//#include "LLF_COMMON_HwDefs.h"




/* canceling the lint warning:
   Use of goto is deprecated */
/*lint --e{801} */

/* canceling the lint warning:
   suspisious pointer conversion */
/*lint --e{826} */

/************************ Defines ******************************/

/************************ Enums ************************************/

/************************ Typedefs *********************************/

/************************ Global Data ******************************/
/*********************************************************************************************************/
/************************              Pubic Functions                      ******************************/
/*********************************************************************************************************/

/************************************************************************************************
 * Function Name: 
 *   CRYS_ATP_TST_CSI_Write
 *
 * Inputs:
 *   DxUint8_t DataIn_ptr        -  The pointer to the users data intput buffer .
 *   Dxuint8_t DataOut_ptr       -  The pointer to the users data output buffer .
 *   DxUint32_t DataSize          -  The test data size, must be not great than 4KB (max FiFo size).
 *   TST_CSI_IN_OUT_Mode_t TST_InOutMode   -  The input-output mode (combination of CSI and DMA), 
 *                                 defined in enumerator.
 * 
 * @return CRYSError_t - On success CRYS_OK or an error is returned
 * 
 * Description: write function initializes the CSI master registers and initializes
 *              the FiFo memory for testing crypto functions on CSI mode. This function
 *              comes to demonstartes writing to the flash 
 ************************************************************************************************/                              
 CRYSError_t  CRYS_ATP_TST_CSI_Write( DxUint8_t*                DataIn_ptr ,
                                      DxUint8_t*                DataOut_ptr ,
                                      DxUint32_t                DataInSize,
                                      TST_OTF_CSI_IN_OUT_Mode_t TST_InOutMode)                   
{
   /* LOCAL DECLERATIONS */
   
   /* The return error identifiers */
   CRYSError_t Error = CRYS_OK;
   
    /* HW virtual base address */
   DxUint32_t  VirtualHwBaseAddr = 0xC0000000;
         
   /* loop variable */
   DxUint8_t i;
   
   /* data alignements */
   DxUint32_t DataOutAlignemnt;
   DxUint32_t DataInAlignemnt;
   
   /* temp variables */
   DxUint32_t OneWord;
   DxUint32_t NumWordsToInput;
   
   /* offset for data address in FiFo */
   DxUint32_t FiFoAddr;
  
   /* FUNCTION LOGIC */
   
   /* .................... initialize local variables ......................... */
   
   DataInAlignemnt   = (DxUint32_t)DataIn_ptr  & 0x03;  
   DataOutAlignemnt  = (DxUint32_t)DataOut_ptr & 0x03;
    
   /* checking of the input data size */  
   if( DataInSize + DataInAlignemnt > HW_ENV_FIFO_MAX_SIZE ||
       DataInSize + DataOutAlignemnt > HW_ENV_FIFO_MAX_SIZE ) 
         return CRYS_COMMON_TST_CSI_DATA_SIZE_EXCEED_ERROR;
   
   /* ............  CSI  output initializations ............................... */
   /* ------------------------------------------------------------------------- */
     
   if( TST_InOutMode == CSI_TST_OTF_CSI_TO_CSI || TST_InOutMode == CSI_TST_OTF_DMA_TO_CSI )
   {
     /* set the CSI read alignment register  */ 
 		 CRYS_PLAT_SYS_WriteRegister( VirtualHwBaseAddr + HW_ENV_CSI_MASTER_RD_ALIGN_ADDR ,
                                  DataOutAlignemnt | DataOutAlignemnt << 2 );
     
     if(TST_InOutMode == CSI_TST_OTF_CSI_TO_CSI) 
     {
        /* set the read bytes for CSI OUt only in case of OTF. In case of CSI, the CRYS code will use the CSI_StartOutput operation to configure this */
  		 CRYS_PLAT_SYS_WriteRegister( VirtualHwBaseAddr + HW_ENV_CSI_BYTES_TO_RD_ADDR ,
                                         DataInSize );
     }
                                  
   }

  
   /* ........................ CSI input initializations  ..................... */
   /* ------------------------------------------------------------------------- */    
      
   if( TST_InOutMode == CSI_TST_OTF_CSI_TO_CSI || TST_InOutMode == CSI_TST_OTF_CSI_TO_DMA )
   {
       /* set the CSI write alignment register  */
	     CRYS_PLAT_SYS_WriteRegister( VirtualHwBaseAddr + HW_ENV_CSI_MASTER_WR_ALIGN_ADDR ,
                                    DataInAlignemnt | DataInAlignemnt << 2 );
       
        /* initialize FiFo address and OneWord buffer */
       FiFoAddr = HW_ENV_CSI_WR_FIFO_ADDR;
       OneWord = 0; 
        
       /* copy valid bytes of first word from input memory into OneWord buffer and into FiFo */       
       DX_VOS_FastMemCpy( (DxUint8_t*)&OneWord + DataInAlignemnt, DataIn_ptr, 4 - DataInAlignemnt );
       CRYS_PLAT_SYS_WriteRegister( VirtualHwBaseAddr + FiFoAddr , OneWord );
       
       /* update remaining DataSise and move DataOut pointer to next (aligned) position */
       DataInSize = DataInSize - (4 - DataInAlignemnt);
       DataIn_ptr = DataIn_ptr + 4 - DataInAlignemnt;         
       
       /* Calculate remaining NumWordsToInput and Fifo address for next aligned word */         
       NumWordsToInput = DataInSize / 4;
     #ifdef LLF_COMMON_TST_NO_FIFO  
       FiFoAddr = FiFoAddr + 4;
     #endif  
       
       /* ........... write remaining aligned words of data into FiFo .............. */
       
       for( i = 0; i < NumWordsToInput; i++)
       {              
       	  CRYS_PLAT_SYS_WriteRegister( VirtualHwBaseAddr + FiFoAddr , *(DxUint32_t*)DataIn_ptr );

          DataIn_ptr = DataIn_ptr + 4;
            
          #ifdef LLF_COMMON_TST_NO_FIFO
           FiFoAddr = FiFoAddr + 4;
         #endif
       }
       
       /* if data is not aligned copy the last non aligned bytes into FiFo */ 
       if( DataInAlignemnt != 0 )
       {
          OneWord = 0;
       	  /* copy valid bytes of last word into OneWord buffer */         
          DX_VOS_FastMemCpy( (DxUint8_t*)&OneWord , DataIn_ptr, DataInAlignemnt );

       	  CRYS_PLAT_SYS_WriteRegister( VirtualHwBaseAddr + FiFoAddr , OneWord );         	  
       }        
   }

   return Error;
   
}                                        

/************************************************************************************************
 * Function Name: 
 *   CRYS_ATP_TST_CSI_Read
 *
 * Inputs:
 *   DxUint8_t DataOut_ptr       -  The pointer to the users data output buffer .
 *   DxUint32_t DataSize          -  The test data size, must be not great than 4KB (max FiFo size).
 *   TST_CSI_IN_OUT_Mode_t TST_InOutMode   -  The input-output mode (combination of CSI and DMA), 
 *                                 defined in enumerator.
 * 
 * @return CRYSError_t - On success CRYS_OK or an error is returned
 * 
 * Description: the function finishes the CSI operations and output of the 
 *              result data from the FiFo memory. 
 ************************************************************************************************/                              
 CRYSError_t  CRYS_ATP_TST_CSI_Read( DxUint8_t                 *DataOut_ptr,
				                     DxUint32_t                 DataInSize,
				                     TST_OTF_CSI_IN_OUT_Mode_t  TST_InOutMode )                   
{
   /* LOCAL DECLARATIONS */
   
   /* The return error identifiers */
   CRYSError_t Error = CRYS_OK;
   
   /* HW virtual base address */
   DxUint32_t  VirtualHwBaseAddr;
         
   /* loop variable */
   DxUint8_t i;
   
   /* data alignement variables */
   DxUint32_t DataOutAlignemnt;
   
   /* temp variables */
   DxUint32_t OneWord;
   DxUint32_t NumWordsToOutput;
   
   /* offset for data address in FiFo */
   DxUint32_t FiFoAddr;
 

   /* FUNCTION LOGIC */
      
   /* .................... initialize local variables ......................... */
  
   DataOutAlignemnt  = (DxUint32_t)DataOut_ptr & 0x03;

   /* set HW virtual base address from global buffer */   
   VirtualHwBaseAddr = 0xC0000000;

   /* ........................ CSI output  .................................... */
   /* ------------------------------------------------------------------------- */
   
   if( TST_InOutMode == CSI_TST_OTF_CSI_TO_CSI || TST_InOutMode == CSI_TST_OTF_DMA_TO_CSI )
   {                               
       /* read the first ( aligned or non aligned word) from FiFo */              
       CRYS_PLAT_SYS_ReadRegister( VirtualHwBaseAddr + HW_ENV_CSI_RD_FIFO_ADDR, OneWord );  
       
       
       /* copy valid bytes of first word into output memory */         
       DX_VOS_FastMemCpy( DataOut_ptr, (DxUint8_t*)&OneWord + DataOutAlignemnt, 4 - DataOutAlignemnt );
       
       /* update remaining DataSise and move DataOut pointer to next (aligned) position */
       DataInSize  = DataInSize - (4 - DataOutAlignemnt);
       DataOut_ptr = DataOut_ptr + 4 - DataOutAlignemnt;         
       
       /* Calculate remaining NumWordsToInput and Fifo address for next aligned word */         
       NumWordsToOutput = DataInSize / 4;  
       
       FiFoAddr = HW_ENV_CSI_RD_FIFO_ADDR; 
          
     #ifdef LLF_COMMON_TST_NO_FIFO 
       FiFoAddr = HW_ENV_CSI_WR_RAM_ADDR + 4;
     #endif
       
       /* ........... read remaining aligned words of data from FiFo .............. */
       
       for( i = 0; i < NumWordsToOutput; i++)
       {              
       	  CRYS_PLAT_SYS_ReadRegister( VirtualHwBaseAddr + FiFoAddr , *(DxUint32_t*)DataOut_ptr );

            DataOut_ptr = DataOut_ptr + 4;
        
          #ifdef LLF_COMMON_TST_NO_FIFO
            FiFoAddr = FiFoAddr + 4;
          #endif   
       }
       
       /* if data is not aligned copy the last non aligned bytes from FiFo */ 
       if( DataOutAlignemnt != 0 )
       {
       	  CRYS_PLAT_SYS_ReadRegister( VirtualHwBaseAddr + FiFoAddr , OneWord );
       	  
       	  /* copy valid bytes of first word into output memory */         
            DX_VOS_FastMemCpy( DataOut_ptr, (DxUint8_t*)&OneWord , DataOutAlignemnt );
       }

   }
   
   return Error;
}                                      

